# ADN Installation 
basierend auf branch adn_8_streckenzeugnis_pruefung

## LAMP
### Apache
```shell
> dnf install httpd
> setsebool -P httpd_can_network_connect on
> setsebool -P httpd_can_network_connect_db on
> setsebool -P httpd_can_sendmail on

> vi /etc/httpd/conf.d/adn.conf
Alias /wsv/adn /var/www/html
<VirtualHost *:80>
  DocumentRoot /var/www/html
  ServerAdmin support-email@itzbund.de
  ServerName adn-strackenzeugnis.app.dlz-it.de
  ServerAlias localhost

  <Directory /var/www/html>
    Options FollowSymLinks
    AllowOverride all
    Require all granted
  </Directory>

  SetEnv ADN_PROXY_URI "/wsv/adn" 
</VirtualHost>
```

### PHP 
```shell
> dnf install epel-release -y
> dnf install https://rpms.remirepo.net/enterprise/remi-release-9.rpm
> dnf module reset php
> dnf module install php:remi-8.0
> dnf install php-xml php-tidy php-soap php-pdo php-gd php-ldap php-mysql php-mbstring composer
> vi /etc/php.ini
memory_limit
post_max_size
max_execution_time
upload_max_filesize
> systemctl enable php-fpm.service
> service php-fpm start
```


### MariaDB
```shell
> dnf install mariadb-server
> systemctl enable mariadb
> service mariadb start
> mysql_secure_installation
> vi /etc/my.conf.d/mariadb-server.cnf

[mysqld]
...
#
# * Fine Tuning
#
innodb_large_prefix = 1
innodb_file_format = Barracuda
innodb_default_row_format = dynamic
innodb_file_per_table = 1
innodb_buffer_pool_instances    = 4
innodb_buffer_pool_size = 2G
innodb_log_file_size = 2G

table_open_cache = 1000
join_buffer_size = 500K
query_cache_type = 1
query_cache_size = 100M

key_buffer_size         = 16M
max_allowed_packet      = 16M
thread_stack            = 192K
thread_cache_size       = 8

> service mysql restart
> mysql -u root -p 
mysql>create database adn charset utf8 collate utf8_general_ci;
mysql>create user 'adn'@'localhost' identified by 'password';
mysql>grant all privileges ON adn.* TO 'adn'@'localhost';
mysql>flush privileges;
```

## ILIAS Installation

```shell
> mkdir -p /var/log/adn/errors
> chown -R apache:apache /var/log/adn
> mkdir /var/www/data
> chown -R apache:apache /var/www/data
> rsync -avz {SOURCE_GIT} /var/www/html
> chown -R apache:apache /var/www/html
```

## SE-Linux
```shell
> semanage fcontext -a -t httpd_log_t "/var/log/adn(/.*)?"
> restorecon -Rv /var/log/adn
> semanage fcontext -a -t httpd_log_t "/var/log/adn/errors(/.*)?"
> restorecon -Rv /var/log/adn/errors
> semanage fcontext -a -t httpd_sys_rw_content_t "/var/www/data(/.*)?"
> restorecon -Rv /var/www/data
> semanage fcontext -a -t httpd_sys_content_t "/var/www/html(/.*)?"
> semanage fcontext -a -t httpd_sys_rw_content_t "/var/www/html/data(/.*)?"
> semanage fcontext -a -t httpd_sys_rw_content_t "/var/www/html/Customizing(/.*)?"
> restorecon -Rv /var/www/html

```



